/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.fabric.cobalt.network;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkHandlerImpl
extends NetworkHandler.Impl {
    private final Map<Class<?>, class_2960> identifiers = new HashMap();

    private <T> class_2960 createMessageIdentifier(String namespace, Class<T> msg) {
        return new class_2960(namespace, msg.getSimpleName().toLowerCase(Locale.ROOT));
    }

    private class_2960 getMessageIdentifier(Message msg) {
        return Objects.requireNonNull(this.identifiers.get(msg.getClass()), "Used unregistered message!");
    }

    @Override
    public <T extends Message> void registerMessage(String namespace, Class<T> msg, Function<class_2540, T> constructor) {
        class_2960 identifier = this.createMessageIdentifier(namespace, msg);
        this.identifiers.put(msg, identifier);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (server, player, handler, buffer, responder) -> {
            Message m = (Message)constructor.apply(buffer);
            server.execute(() -> m.receive((class_1657)player));
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.register(identifier, constructor);
        }
    }

    @Override
    public void sendToServer(Message msg) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        msg.encode(buf);
        ClientPlayNetworking.send((class_2960)this.getMessageIdentifier(msg), (class_2540)buf);
    }

    @Override
    public void sendToPlayer(Message msg, class_3222 e) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        msg.encode(buf);
        ServerPlayNetworking.send((class_3222)e, (class_2960)this.getMessageIdentifier(msg), (class_2540)buf);
    }

    @Override
    public void sendToTrackingPlayers(Message msg, class_1297 origin) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        msg.encode(buf);
        for (class_3222 player : PlayerLookup.tracking((class_1297)origin)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.getMessageIdentifier(msg), (class_2540)buf);
        }
    }

    private static final class ClientProxy {
        private ClientProxy() {
            throw new RuntimeException("new ClientProxy()");
        }

        public static <T extends Message> void register(class_2960 id, Function<class_2540, T> constructor) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, ignore1, buffer, ignore2) -> {
                Message m = (Message)constructor.apply(buffer);
                client.execute(() -> m.receive((class_1657)client.field_1724));
            });
        }
    }
}

